<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<HTML>
	<HEAD>
		<title>IBChart Sample</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

		<script type="text/javascript" src="../Chart/jquery-1.7.2.min.js"></script>
		<script type="text/javascript" src="../js/common.js"></script>
		<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
		<script type="text/javascript" src="../Chart/ibchart.js"></script>
		<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
	</HEAD>
	<script type="text/javascript">
		function PageLoad() {
			var CHART_OPT = {
				chart:{
					type:"column",
					borderColor:"#99BCE8",
					backgroundColor:"#C9E1F5",
					borderWidth:1,
					borderRadius:4,
					plotBackgroundColor:"#FFFFFF",
					plotBorderWidth:2,
					plotBorderColor:"#99BCE8"
				},
				title:{
					style:{
						color:"#15498B",
						fontFamily:"Dotum",
						fontWeight:"bold"
					}
				},
				subtitle:{
					style:{
						fontFamily:"Dotum"
					}
				},
				xAxis:{
					gridLineColor:"#333333",
					tickColor:"#333333",
					labels:{
						formatter:function(){
							return this.value + " 년";
						},
						style:{
							fontFamily:"Dotum"
						}
					}
				},
				tooltip:{
					enabled:true,
					style:{
						fontFamily:"Dotum"
					}
				},
				legend:{
					itemStyle:{
						color:"#15498B",
						fontFamily:"Dotum"
					},
					itemHiddenStyle:{
						fontFamily:"Dotum"
					},
					itemHoverStyle:{
						color:"#15498B",
						fontFamily:"Dotum"
					},
					borderColor:"#99BCE8",
					borderWidth:2
				},
				labels:{
					style:{
						color:"#15498B",
						fontFamily:"Dotum",
						fontWeight:"bold"
					}
				},
				yAxis:[{
					gridLineColor:"#333333",
					tickColor:"#333333",
					tickInterval:5000,
					labels:{
						formatter:function(){
							return this.value;
						},
						style:{
							fontFamily:"Dotum"
						}
					},
					title:{
						style:{
							fontFamily:"Dotum",
							color:"#15498B"
						},
						text:"총인구(천명)"
					}
				},{
					opposite:true,
					gridLineColor:"#333333",
					gridLineDashStyle:"dot",
					tickColor:"#333333",
					tickInterval:0.2,
					labels:{
						formatter:function(){
							return this.value + " %";
						},
						style:{
							fontFamily:"Dotum"
						}
					},
					title:{
						style:{
							fontFamily:"Dotum",
							color:"#15498B"
						},
						text:"성장률(%)"
					}
				}],
				events: {
					searchEnd: myChart_OnSearchEnd
				}
			};

			createIBChart("myChart", "myChart", {
				width: "100%",
				height: "100%"
			});

			myChart.setOptions(CHART_OPT);
			DoSearch(myChart, "practice6_data.xml");
		}

		function DoSearch(chart,url,subparam){
			$.ajax({
				type: 'post'
				, async: true
				, dataType:"text"
				, url: url
				, data: subparam
				, beforeSend: function() {

				}
				, success: function(xml) {
					chart.loadSearchData(xml,{
						append: true
					});
				}
				, error: function(data, status, err) {
					alert('서버와의 통신이 실패했습니다.');
				}
				,complete:function(jqXHR,textStatus){

				}
			});
		}

		//조회 후에 일부 설정을 변경한다.
		function myChart_OnSearchEnd(code, msg){
			//두번째 시리즈를 라인 차트로 변경하고 Y2축(오른쪽 Y축)에 할당 한다.
			myChart.series(0).setOptions({
				zIndex:1
			}, {
				append: true
			});
			myChart.series(1).setOptions({
				type : "line",
				color : "#FF5674",
				zIndex:2,
				yAxis:1
			}, {
				append: true
			});

			//별도 레이블(타이틀) 설정
			myChart.setOptions({
				labels:{
					items:[{
						html:"* 인구성장률은 전년대비 인구변화율임",
						style:{
							left: "5px",
							top:'-15px'
						}
					}]
				}
			}, {
				append: true,
				redraw: true
			});
		}
	</script>
	<body onload="PageLoad();">
		<div class="page_title">
        <span><a class="closeDepth" href="#">closeDepth</a></span>
        <span class="title color_sheet">차트개발 실습 > <b>2개 Y축</b></span>
		</div>
			<div class="main_content">
			<div class="exp_product">
				2개 Y축을 생성하여 차트를 표시합니다.
			</div>

			<div class="ib_function float_right">
			</div>

			<div class="clear hidden"></div>

			<!--div class="ib_function2 border_chart">
			</div-->

				<p class="subtit_chart">차트 조회</p>
		  <div class="ib_product">
			<div id="myChart"></div>
		  </div>
		</div>
	</body>
</HTML>
